﻿Scriptname _SLSubmitFunctions extends Quest  

_SLSubmitConfig Property _SLConfig Auto
_SLSubmitQuest Property _SLQuest auto
_SLSubmitScene Property _SLScene Auto
;SexLabFramework Property SexLab  Auto  
;sslConfigMenu Property SexLabConfig  Auto

; DD Libraries and variables
ZadLibs Property Libs auto
ZadxLibs Property LibsX auto
String[] Property bondageAnimations Auto
String[] Property indoorBondageAnimations Auto
Spell Property Shock Auto

; Fade in and out effects
ImageSpaceModifier Property FadeToBlack Auto
ImageSpaceModifier Property HoldBlack Auto
ImageSpaceModifier Property FadeFromBlack Auto

; Modified DD devices for debuffs
Armor Property collarPostureSteel Auto
Armor Property leatherArms Auto
Armor Property leatherCollar Auto
Armor Property leatherLegs Auto
Armor Property leatherLegsRendered Auto
Armor Property paddedArms Auto
Armor Property paddedCollar Auto
Armor Property paddedLegs Auto
Armor Property paddedLegsRendered Auto
Armor Property harnessBody Auto
Armor Property harnessCollar Auto
Armor Property latexCollar Auto ; Latex devices added in 2.8.0
Armor Property latexHarnessCollar Auto
Armor Property latexHarnessBody Auto
Armor Property latexArms Auto
Armor Property latexLegs Auto
Armor Property latexLegsRendered Auto

; Auto surrender variables
Location[] Property BlackBookLocations Auto
Bool autoSubmitLock=False

; Surrender variables
Bool playerCaptured=False

Actor Property playerRef Auto

ReferenceAlias Property ActorAssailant1  Auto  
ReferenceAlias Property ActorAssailant2  Auto  
ReferenceAlias Property ActorAssailant3  Auto  
ReferenceAlias Property ActorAssailant4  Auto  
ReferenceAlias Property ActorAssailant5  Auto  
ReferenceAlias Property ActorAssailant6  Auto  
ReferenceAlias Property ActorFollower  Auto
ReferenceAlias Property ActorBully Auto

GlobalVariable Property _SLSubmitSurrenderGlobal  Auto
GlobalVariable Property _SLSubmitBleedoutGlobal  Auto
GlobalVariable Property _SLSubmitHardcoreBindings Auto
Package Property BullyPackage Auto
Spell Property _SLSubmitAssign  Auto  
Spell Property _SLSubmitBullyCloak Auto
Spell Property _SLSubmitSurrender  Auto
Spell Property _SLSubmitRepeat5  Auto
Spell Property _SLSubmitRepeat10  Auto
Spell Property _SLSubmitRepeat15  Auto

Weapon Property MainHand  Auto  
Weapon Property OffHand  Auto  
Spell Property LSpell Auto
Spell Property RSpell Auto
Spell Property _SLSubmitUnarmed Auto
Armor Property Shield Auto
Armor Property Body Auto
Armor Property Boot Auto
Armor Property Glove Auto
Armor Property Helm Auto
Armor Property Necklace Auto
Armor Property Ring Auto

Weapon Property VictimWeapon1  Auto  
Weapon Property VictimWeapon2  Auto  
Weapon Property MainHand2  Auto  
Weapon Property OffHand2  Auto  
Spell Property LSpell2 Auto
Spell Property RSpell2 Auto
Armor Property Shield2 Auto

Int Property VampireStatus Auto Conditional
Message Property VampireFeedMessage Auto
Message Property VampireStageProgressionMessage Auto
Faction Property VampirePCFaction  Auto  
Float Property LastFeedTime Auto
Float Property FeedTimer Auto
GlobalVariable Property GameDaysPassed Auto
Idle Property _SLSubmitFeed Auto
Idle Property VampireFeedingBedRight Auto
Idle Property VampireFeedingBedrollRight Auto
GlobalVariable Property VampireFeedReady Auto
imageSpaceModifier Property VampireTransformIncreaseISMD  Auto
imageSpaceModifier Property VampireTransformDecreaseISMD  Auto 
effectShader property VampireChangeFX auto
FormList Property CrimeFactions  Auto  

; ==============================
;	Initialization
; ==============================
Function InitializeBlackBooks()
	Log("InitializeBlackBooks()")
	BlackBookLocations = new Location[7]
	BlackBookLocations[0] = Game.GetFormFromFile(0x142B0, "Dragonborn.esm") as Location
	BlackBookLocations[1] = Game.GetFormFromFile(0x1EE08, "Dragonborn.esm") as Location
	BlackBookLocations[2] = Game.GetFormFromFile(0x142AF, "Dragonborn.esm") as Location
	BlackBookLocations[3] = Game.GetFormFromFile(0x1EE06, "Dragonborn.esm") as Location
	BlackBookLocations[4] = Game.GetFormFromFile(0x142AC, "Dragonborn.esm") as Location
	BlackBookLocations[5] = Game.GetFormFromFile(0x1EE07, "Dragonborn.esm") as Location
	BlackBookLocations[6] = Game.GetFormFromFile(0x142AE, "Dragonborn.esm") as Location
EndFunction

; ==============================
;	Original Submit functions
; ==============================
Function UnArm(Actor Target)
	Log("UnArm(" + Target + ")")
	MainHand = Target.getEquippedWeapon()
	OffHand = Target.getEquippedWeapon(True)
	Shield = Target.getEquippedShield()
	LSpell = Target.getEquippedSpell(0)
	RSpell = Target.getEquippedSpell(1)
	_SLScene.WRT(0.1)
	If (MainHand != none)
		Target.UnEquipItem( MainHand, false, true)
	EndIf
	If (OffHand != none)
		_SLScene.WRT(0.1)
		Target.UnEquipItem( OffHand, false, true)
	EndIf
	If (Shield != none)
		Target.UnEquipItem( Shield, false, true)
	EndIf
	If (LSpell != none)
		Target.UnEquipSpell( LSpell, 0)
	EndIf
	If (RSpell != none)
		_SLScene.WRT(0.1)
		Target.UnEquipSpell( RSpell, 1)
	EndIf
EndFunction

Function UnArm2(Actor Target)
	Log("UnArm2(" + Target + ")")
	MainHand2 = Target.getEquippedWeapon()
	OffHand2 = Target.getEquippedWeapon(True)
	Shield2 = Target.getEquippedShield()
	LSpell2 = Target.getEquippedSpell(0)
	RSpell2 = Target.getEquippedSpell(1)
	_SLScene.WRT(0.1)
	If (MainHand2 != none)
		Target.UnEquipItem( MainHand2, false, true)
	EndIf
	If (OffHand2 != none)
		_SLScene.WRT(0.1)
		Target.UnEquipItem( OffHand2, false, true)
	EndIf
	If (Shield2 != none)
		Target.UnEquipItem( Shield2, false, true)
	EndIf
	If (LSpell2 != none)
		Target.UnEquipSpell( LSpell2, 0)
	EndIf
	If (RSpell2 != none)
		_SLScene.WRT(0.1)
		Target.UnEquipSpell( RSpell2, 1)
	EndIf
EndFunction

Function ReArm(Actor Target)
	Log("ReArm(" + Target + ")")
	Target.AddSpell(_SLSubmitUnarmed, false)
	Target.EquipSpell( _SLSubmitUnarmed, 1)
	_SLScene.WRT(0.1)
	Target.UnEquipSpell( _SLSubmitUnarmed, 1)
	Target.RemoveSpell(_SLSubmitUnarmed)
	If (MainHand != none)
		Target.EquipItemEx( MainHand,1, false, true)
	EndIf
	If (Shield != none)
		Target.EquipItemEx( Shield, 0, false, true)
	EndIf
	If (OffHand != none)
		_SLScene.WRT(0.1)
		Target.EquipItemEx( OffHand,2, false, true)
	EndIf
	If (LSpell != none)
		Target.EquipSpell( LSpell, 0)
	EndIf
	If (RSpell != none)
		_SLScene.WRT(0.1)
		Target.EquipSpell( RSpell, 1)
	EndIf
EndFunction

Function ReArm2(Actor Target)
	Log("ReArm2(" + Target + ")")
	Target.AddSpell(_SLSubmitUnarmed, false)
	Target.EquipSpell( _SLSubmitUnarmed, 1)
	_SLScene.WRT(0.1)
	Target.UnEquipSpell( _SLSubmitUnarmed, 1)
	Target.RemoveSpell(_SLSubmitUnarmed)
	If (MainHand2 != none)
		Target.EquipItemEx( MainHand2,1, false, true)
	EndIf
	If (Shield2 != none)
		Target.EquipItemEx( Shield2, 0, false, true)
	EndIf
	If (OffHand2 != none)
		_SLScene.WRT(0.1)
		Target.EquipItemEx( OffHand2,2, false, true)
	EndIf
	If (LSpell2 != none)
		Target.EquipSpell( LSpell2, 0)
	EndIf
	If (RSpell2 != none)
		_SLScene.WRT(0.1)
		Target.EquipSpell( RSpell2, 1)
	EndIf
EndFunction

Function SubmitFeed()
	Log("SubmitFeed()")
	;Effects for hiding the change
	;VampireChangeFX.play(PlayerRef)
	VampireTransformDecreaseISMD.applyCrossFade(2.0)
	_SLScene.WRT(2.0)
	imageSpaceModifier.removeCrossFade()
	;VampireChangeFX.stop(PlayerRef)
	
	Game.IncrementStat( "Necks Bitten" )
	VampireFeedMessage.Show()
	VampireFeedReady.SetValue(0)
	;Game.ForceThirdPerson()
	;PlayerRef.PlayIdle(VampireFeedingBedRight)
	;Player has fed, regress to Stage 1 Vampirisim
	;Remove Stage 2, 3, and 4 buffs and spells
	LastFeedTime =  GameDaysPassed.Value
	VampireStatus = 1
;	PVQ.VampireProgression(PlayerRef, 1)
	;Player is no longer hated
	PlayerRef.RemoveFromFaction(VampirePCFaction)
	PlayerRef.SetAttackActorOnSight(False)

	int cfIndex = 0
	while (cfIndex < CrimeFactions.GetSize())
; 		Debug.Trace("VAMPIRE: Removing enemy flag from " + CrimeFactions.GetAt(cfIndex))
		(CrimeFactions.GetAt(cfIndex) as Faction).SetPlayerEnemy(false)
		cfIndex += 1
	endwhile
	;Start checking GameTime again if we weren't already
	UnregisterforUpdateGameTime()
	RegisterForUpdateGameTime(12)
EndFunction

Function ClearAssailants()
	Log("ClearAssailants()")
	If (ActorAssailant1.GetActorRef() != None)
		ActorAssailant1.Clear()
	EndIf
	If (ActorAssailant2.GetActorRef() != None)
		ActorAssailant2.Clear()
	EndIf
	If (ActorAssailant3.GetActorRef() != None)
		ActorAssailant3.Clear()
	EndIf
	If (ActorAssailant4.GetActorRef() != None)
		ActorAssailant4.Clear()
	EndIf
	If (ActorAssailant5.GetActorRef() != None)
		ActorAssailant5.Clear()
	EndIf
	If (ActorAssailant6.GetActorRef() != None)
		ActorAssailant6.Clear()
	EndIf
	;ActorUtil.RemoveAllPackageOverride(BullyPackage)
	RemovePackageFromAllActors(BullyPackage)
EndFunction

Function RecheckAssailants()
	Log("RecheckAssailants()")
	ClearAssailants()
	_SLSubmitSurrenderGlobal.SetValue(1)
	_SLSubmitAssign.Cast(PlayerRef)
	Surrender()
	_SLScene.WRT(2.0)
EndFunction

Function CombatRecover()
	Log("CombatRecover()")
	
	Debug.Notification("You are still in combat!")
	BleedOutStop()
	Game.EnablePlayerControls()
	If (ActorAssailant1.GetActorRef() != None)
		ActorAssailant1.Clear()
	EndIf
	_SLScene.WRT(0.1)
	If (ActorAssailant2.GetActorRef() != None)
		ActorAssailant2.Clear()
	EndIf
	If (ActorFollower.GetActorRef() != None)
		ActorFollower.Clear()
	EndIf
	If (ActorBully.GetActorRef() != None)
		ActorBully.Clear()
	EndIf
	_SLSubmitBullyCloak.Cast(PlayerRef)
	;ActorUtil.RemoveAllPackageOverride(BullyPackage)
	RemovePackageFromAllActors(BullyPackage)
EndFunction

Function BleedOutStop()
	Log("BleedOutStop()")
	_SLSubmitBleedoutGlobal.SetValue(0)
	Debug.SendAnimationEvent(PlayerRef, "BleedOutStop")
	If (ActorFollower.GetActorRef() != None)
		Debug.SendAnimationEvent(ActorFollower.GetActorRef(), "BleedOutStop")
	EndIf
	_SLScene.WRT(2.5)
EndFunction

Function RepeatRate()
	Log("RepeatRate()")
	
	If (_SLConfig.RepeatRate == 5)
		Log("RepeatRate set to 5")
		_SLSubmitRepeat5.Cast(PlayerRef)
	ElseIf (_SLConfig.RepeatRate == 10)
		Log("RepeatRate set to 5")
		_SLSubmitRepeat10.Cast(PlayerRef)
	Else
		Log("RepeatRate set to 5")
		_SLSubmitRepeat15.Cast(PlayerRef)
	EndIf
EndFunction

Function Surrender()
	_SLSubmitSurrender.Cast(playerRef)
EndFunction

Bool Function AutoSurrender()
	If (_SLSubmitSurrenderGlobal.GetValue() == 0 && _SLSubmitHardcoreBindings.GetValue() == 0)
			ClearAssailants()
			_SLSubmitSurrenderGlobal.SetValue(1)
			AcquireSpinlock()
			_SLSubmitAssign.Cast(PlayerRef)
			Surrender()
	EndIf
	AcquireSpinlock()
	If (_SLSubmitSurrenderGlobal.GetValue() != 2)
		ReleaseSpinlock()
		Return False
	EndIf
	ReleaseSpinlock()
	Return True
EndFunction

; ==============================
;	DD Equip functions
; ==============================
Function EquipDevice(Actor akActor, Keyword kW, bool skipEvents = false)
	Log("EquipDevice(" + akActor + "," + kW + ","+ skipEvents + ")")
	
	Armor device = Libs.GetGenericDeviceByKeyword(kW)
	
	If device != None
		Libs.EquipDevice(akActor, device, Libs.GetRenderedDevice(device), kW, skipEvents, false)
	Else
		Error("EquipDevice() None instead of belt retrieved")
	EndIf
EndFunction 

Function EquipBelt(Actor akActor, bool skipEvents = false)
	Log("EquipBelt(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("EquipBelt() called on a None reference")
		return
	EndIf

	Armor belt = Libs.GetGenericDeviceByKeyword(Libs.zad_DeviousBelt)
	
	If belt != None
		VagPiercingChance(akActor, 0, 99, skipEvents)
		EquipPlugs(akActor, true, !Libs.HasTag(belt, "open"), skipEvents)
		Libs.EquipDevice(akActor, belt, Libs.GetRenderedDevice(belt), Libs.zad_DeviousBelt, skipEvents, false)
	Else
		Error("EquipBelt() None instead of belt retrieved")
	EndIf
EndFunction

Function EquipBra(Actor akActor, bool skipEvents = false)
	Log("EquipBra(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("EquipBra() called on a None reference")
		return
	EndIf

	If(akActor.GetActorBase().GetSex() == 1)
		If Utility.RandomInt() < 50
			EquipDevice(akActor, Libs.zad_DeviousBra, skipEvents)
		Else
			EquipDevice(akActor, Libs.zad_DeviousPiercingsNipple, skipEvents)
		EndIf
	EndIf
EndFunction

Function EquipBoots(Actor akActor, bool skipEvents = false)
	Log("EquipBoots(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("EquipBoots() called on a None reference")
		return
	EndIf
	
	EquipDevice(akActor, Libs.zad_DeviousBoots, skipEvents)
EndFunction

Function EquipCollar(Actor akActor, bool skipEvents = false)
	Log("EquipCollar(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("EquipCollar() called on a None reference")
		return
	EndIf
	
	EquipDevice(akActor, Libs.zad_DeviousCollar, skipEvents)
EndFunction 

Function EquipHarness(Actor akActor, bool skipEvents = false)
	Log("EquipHarness(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("EquipHarness() called on a None reference")
		return
	EndIf
	
	EquipPlugs(akActor, true, true, skipEvents)
	EquipDevice(akActor, Libs.zad_DeviousHarness, skipEvents)
EndFunction

Function EquipArmCuffs(Actor akActor, bool skipEvents = false)
	Log("EquipArmCuffs(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("EquipArmCuffs() called on a None reference")
		return
	EndIf
	
	EquipDevice(akActor, Libs.zad_DeviousArmCuffs, skipEvents)
EndFunction

Function EquipLegCuffs(Actor akActor, bool skipEvents = false)
	Log("EquipLegCuffs(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("EquipLegCuffs() called on a None reference")
		return
	EndIf

	EquipDevice(akActor, Libs.zad_DeviousLegCuffs, skipEvents)
EndFunction

Function EquipGag(Actor akActor, bool skipEvents = false)
	Log("EquipGag(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("EquipGag() called on a None reference")
		return
	EndIf

	EquipDevice(akActor, Libs.zad_DeviousGag, skipEvents)
EndFunction

Function EquipBlindFold(Actor akActor, bool skipEvents = false)
	Log("EquipBlindFold(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("EquipBlindFold() called on a None reference")
		return
	EndIf

	EquipDevice(akActor, Libs.zad_DeviousBlindfold, skipEvents)
EndFunction

Function EquipArmbinder(Actor akActor, bool skipEvents = false)
	EquipDevice(akActor, Libs.zad_DeviousArmbinder, skipEvents)
EndFunction

Function EquipPlugs(Actor akActor, bool vagPlug, bool analPlug, bool skipEvents = false)
	Log("EquipPlugs(" + akActor + "," + vagPlug + "," + analPlug + "," + skipEvents + ")")
	
	If akActor == None
		Warn("EquipPlugs() called on a None reference")
		return
	EndIf
	
	; Vaginal plugs only for girls :D
	If akActor.GetActorBase().GetSex() == 1 && vagPlug
		EquipDevice(akActor, Libs.zad_DeviousPlugVaginal, skipEvents)
	EndIf
	
	If analPlug
		EquipDevice(akActor, Libs.zad_DeviousPlugAnal, skipEvents)
	EndIf
EndFunction

; ==============================
;	DD Unequip functions
; ==============================
Armor Function RemoveBelt(Actor akActor, bool skipEvents = false)
	Log("RemoveBelt(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("RemoveBelt() called on a None reference")
		return None
	EndIf
	
	return RemoveDevice(akActor, Libs.zad_DeviousBelt, skipEvents)
EndFunction

Armor Function RemoveBra(Actor akActor, bool skipEvents = false)
	Log("RemoveBra(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("RemoveBra() called on a None reference")
		return None
	EndIf
	
	return RemoveDevice(akActor, Libs.zad_DeviousBra, skipEvents)
EndFunction

Armor Function RemoveBoots(Actor akActor, bool skipEvents = false)
	Log("RemoveBoots(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("RemoveBoots() called on a None reference")
		return None
	EndIf
	
	return RemoveDevice(akActor, Libs.zad_DeviousBoots, skipEvents)
EndFunction

Armor Function RemoveCollar(Actor akActor, bool skipEvents = false)
	Log("RemoveCollar(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("RemoveCollar() called on a None reference")
		return None
	EndIf
	
	return RemoveDevice(akActor, Libs.zad_DeviousCollar, skipEvents)
EndFunction

Armor Function RemoveHarness(Actor akActor, bool skipEvents = false)
	Log("RemoveArmCuffs(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("RemoveArmCuffs() called on a None reference")
		return None
	EndIf
	
	return RemoveDevice(akActor, Libs.zad_DeviousHarness, skipEvents)
EndFunction

Armor Function RemoveArmCuffs(Actor akActor, bool skipEvents = false)
	Log("RemoveArmCuffs(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("RemoveArmCuffs() called on a None reference")
		return None
	EndIf
	
	return RemoveDevice(akActor, Libs.zad_DeviousArmCuffs, skipEvents)
EndFunction

Armor Function RemoveLegCuffs(Actor akActor, bool skipEvents = false)
	Log("RemoveLegCuffs(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("RemoveLegCuffs() called on a None reference")
		return None
	EndIf
	
	return RemoveDevice(akActor, Libs.zad_DeviousLegCuffs, skipEvents)
EndFunction

Armor Function RemoveGag(Actor akActor, bool skipEvents = false)
	Log("RemoveGag(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("RemoveGag() called on a None reference")
		return None
	EndIf
	
	return RemoveDevice(akActor, Libs.zad_DeviousGag, skipEvents)
EndFunction

Armor Function RemoveBlindFold(Actor akActor, bool skipEvents = false)
	Log("RemoveBlindFold(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("RemoveBlindFold() called on a None reference")
		return None
	EndIf
	
	return RemoveDevice(akActor, Libs.zad_DeviousBlindfold, skipEvents)
EndFunction

Armor Function RemoveArmbinder(Actor akActor, bool skipEvents = false)
	Log("RemoveArmbinder(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("RemoveArmbinder() called on a None reference")
		return None
	EndIf
	
	return RemoveDevice(akActor, Libs.zad_DeviousArmbinder, skipEvents)
EndFunction

Armor Function RemoveVagPlug(Actor akActor, bool skipEvents = false)
	Log("RemoveVagPlug(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("RemoveVagPlug() called on a None reference")
		return None
	EndIf
	
	return RemoveDevice(akActor, Libs.zad_DeviousPlugVaginal, skipEvents)
EndFunction

Armor Function RemoveAnalPlug(Actor akActor, bool skipEvents = false)
	Log("RemoveAnalPlug(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("RemoveAnalPlug() called on a None reference")
		return None
	EndIf
	
	return RemoveDevice(akActor, Libs.zad_DeviousPlugAnal, skipEvents)
EndFunction

Armor Function RemoveDevice(Actor akActor, Keyword deviceKeyword, bool skipEvents = false)
	Log("RemoveDevice(" + akActor + "," + deviceKeyword + "," + skipEvents + ")")

	If akActor == None
		Warn("RemoveDevice() called on a None reference")
		return None
	EndIf
	
	If !akActor.WornHasKeyword(deviceKeyword)
		Warn("Cannot remove device because keyword(" + deviceKeyword + ") is missing on actor(" + akActor + ")")
		return None
	EndIf

	Armor device = GetWornDevice(akActor, deviceKeyword)
	
	If device != None
		Armor renderedDevice = Libs.GetRenderedDevice(device)
		Libs.RemoveDevice(akActor, device, renderedDevice, deviceKeyword, true, skipEvents, false)
		return device
	Else
		Warn("RemoveDevice() was not able to remove device with keyword(" + deviceKeyword + ") from actor(" + akActor + ")")
		return None
	EndIf
EndFunction

; ==============================
;	Chance functions
; ==============================
Function BraEquipChance(Actor akActor, int min=0, int max=99, bool skipEvents = false)
	Log("BraEquipChance(" + akActor + "," + min + "," + max + "," + skipEvents + ")")

	If akActor == None
		Warn("BraEquipChance() called on a None reference")
		return
	EndIf
	
	int intBraSelector = Utility.RandomInt(min,max)
	
	If (intBraSelector < (max - min)/2 + min + 1)
		EquipBra(akActor, skipEvents)
	EndIf
EndFunction

Function VagPiercingChance(Actor akActor, int min = 0, int max =99, bool skipEvents = false)
	Log("VagPiercingChance(" + akActor + "," + min + "," + max + "," + skipEvents + ")")
	
	If akActor == None
		Warn("VagPiercingChance() called on a None reference")
		return
	EndIf
	
	int intPiercingSelector = Utility.RandomInt(min,max)
	
	If (intPiercingSelector < (max - min)/2 + min + 1)
		EquipDevice(akActor, Libs.zad_DeviousPiercingsVaginal, skipEvents)
	EndIf
EndFunction

Function ChastityEquipChance(Actor akActor, bool skipEvents = false)
	Log("ChastityEquipChance(" + akActor + "," + skipEvents + ")")
	
	If akActor == None
		Warn("ChastityEquipChance() called on a None reference")
		return
	EndIf
	
	If !akActor.WornHasKeyword(Libs.zad_DeviousCollar) && !akActor.WornHasKeyword(Libs.zad_DeviousBelt) && !akActor.WornHasKeyword(Libs.zad_DeviousHarness)
		;then we can any devices we like
		int intHarnessSelector = Utility.RandomInt(0,99)
			
		if (intHarnessSelector < 50)
			EquipCollar(akActor, skipEvents)				
			EquipBelt(akActor, skipEvents)
		Else	
			EquipHarness(akActor, skipEvents)
		EndIf
	ElseIf !akActor.WornHasKeyword(Libs.zad_DeviousHarness)
		; player has no harness but either collar or belt, add missing device
		If !akActor.WornHasKeyword(Libs.zad_DeviousCollar)
			EquipCollar(akActor, skipEvents)
		Else
			EquipBelt(akActor, skipEvents)
		EndIf
	EndIf
	
	; May add bra
	If !akActor.WornHasKeyword(Libs.zad_DeviousBra)
			BraEquipChance(akActor, 0, 99, skipEvents)
	EndIf
EndFunction

; ==============================
;	Mutex functions
; ==============================
Bool Function IsInBook()
	Log("IsInBook()")
	int i = 0
	While i < BlackBookLocations.Length
		If PlayerRef.IsInLocation(BlackBookLocations[i])
			return True
		EndIf
		i += 1
	EndWhile
	
	return False
EndFunction

Bool Function IsCaptured()
	Log("IsCaptured()")
	return playerCaptured
EndFunction

Function SetCaptured(Bool playerIsCaptured)
	Log("SetCaptured(" + playerIsCaptured + ")")
	playerCaptured = playerIsCaptured
EndFunction

; ==============================
;	Utility functions
; ==============================

; Modified version in order to work for the followers.
; NPCs do NOT always have inventory items equipped for some reason.
; This version of GetWornDevice checks for the script instance as well.
;
; Returns the currently equipped inventory device matching the supplied keyword.
Armor Function GetWornDevice(Actor akActor, Keyword kw)
	Log("GetWornDevice(" + akActor + "," + kw + ")")
	If akActor == PlayerRef
		return Libs.GetWornDevice(akActor, kw)
	Else
		Armor retval = none
		Int iFormIndex = akActor.GetNumItems()
		bool breakFlag = false
		While iFormIndex > 0 && !breakFlag
			iFormIndex -= 1
			Form kForm = akActor.GetNthForm(iFormIndex)
			If kForm.HasKeyword(Libs.zad_InventoryDevice)
				ObjectReference tmpORef = akActor.placeAtMe(kForm, abInitiallyDisabled = true)
				zadEquipScript tmpZRef = tmpORef as zadEquipScript
				if tmpZRef != none && tmpZRef.zad_DeviousDevice == kw && akActor.GetItemCount(tmpZRef.deviceRendered) > 0 && (akActor.IsEquipped(kForm) || akActor.IsEquipped(tmpZRef.deviceRendered))
					retval = kForm as Armor
					breakFlag = true
				Endif
				tmpORef.delete()
			EndIf
		EndWhile
		return retval
	EndIf
EndFunction

Function DoFadeOut()
	Log("DoFadeOut()")
	FadeToBlack.Apply()
	Utility.Wait(3)
	FadeToBlack.PopTo(HoldBlack)
EndFunction

Function DoFadeIn()
	Log("DoFadeIn()")
	HoldBlack.PopTo(FadeFromBlack)
	HoldBlack.Remove()
	Utility.Wait(3)
	FadeFromBlack.Remove()
EndFunction

Function SetAnimating(Actor akActor, bool isAnimating=true)
	Log("SetAnimatiing(" + akActor + "," + isAnimating + ")")
	Libs.SetAnimating(akActor, isAnimating)
EndFunction

Function Moan(Actor akActor)
	Log("Moan(" + akActor + ")")
	shock.RemoteCast(akActor, akActor, akActor)
	Libs.SexlabMoan(akActor,-1)
EndFunction

Function SetBondageAnimation(Actor akActor)
	Log("SetBondageAnimation(" + akActor + ")")
	
	int i = 0
	If akActor.IsInInterior()
		i = Randomizer(indoorBondageAnimations.Length, 1000) - 1
		Debug.SendAnimationEvent(akActor, indoorBondageAnimations[i])
		Log("Playing Animation(" + indoorBondageAnimations[i] + ") on actor(" + akActor + ")")
	Else
		i = Randomizer(bondageAnimations.Length, 1000) - 1
		Debug.SendAnimationEvent(akActor, bondageAnimations[i])
		Log("Playing Animation(" + bondageAnimations[i] + ") on actor(" + akActor + ")")
	EndIf
EndFunction

int Function SetDeviceMax(int level)
	Log("SetDeviceMax(" + level + ")")
	; Comments conditions:
	; First surrender
	; Player does not have any devices equipped
	
	int maxDevices = 0
	
	; Get the maximum item count based on player's level
	If(level <= 5)
		return maxDevices ; no items we are merciful today 
	ElseIf(level <= 10)
		maxDevices = 2 ; Add arm cuffs
	ElseIf(level <= 15)
		maxDevices = 3 ; Add arm cuffs + leg cuffs
	ElseIf(level <= 20)
		maxDevices = 4 ; Add arm cuffs + leg cuffs + belt/collar or harness
	ElseIf(level <= 25)
		maxDevices = 5 ; Add arm cuffs + leg cuffs + belt/collar or harness + boots
	ElseIf(level <= 30)
		maxDevices = 6 ; Add arm cuffs + leg cuffs + belt/collar or harness + boots + gag
	ElseIf(level <= 35)
		maxDevices = 7 ; Add arm cuffs + leg cuffs + belt/collar or harness + boots + gag + blindfold
	ElseIf(level <= 35)
		maxDevices = 8 ; Add arm cuffs + leg cuffs + belt/collar or harness + boots + blindfold + armbinder
	Else
		maxDevices = 9 ; Add arm cuffs + leg cuffs + belt/collar or harness + boots + gag + blindfold + armbinder
	EndIf
	
	; Calculate a random value between 0 and maximum items
	float calcDevices = (Randomizer(maxDevices, 100) - 1) as float
	
	; Calculate modifiers into the value
	If _SLQuest.Alduin.IsCompleted()
		; Dragon slayer looks pretty dangerous to bandits
		calcDevices *= 1.15
	EndIf
	If _SLQuest.Harbingers.IsCompleted()
		calcDevices *= 1.1
	EndIf
	If _SLQuest.Thieves.IsCompleted()
		; Bandits respect criminals
		calcDevices /= 1.1
	EndIf
	If _SLQuest.College.IsCompleted()
		calcDevices *= 1.1
	EndIf
	If _SLQuest.Brotherhood.IsCompleted()
		calcDevices /=1.1
	EndIf
	If playerRef.HasPerk(_SLQuest.Dibella)
		; Gods might help the player a little
		If Utility.RandomInt() > 49
			calcDevices /= 1.02
		EndIf
	EndIf
	If playerRef.HasPerk(_SLQuest.Mara)
		If Utility.RandomInt() > 49
			calcDevices /= 1.02
		EndIf
	EndIf
	
	; Round modified value
	calcDevices += 0.5
	
	; Make sure value is in level range
	If calcDevices > maxDevices
		calcDevices = maxDevices
	ElseIf calcDevices < 0
		calcDevices = 0
	EndIf
	
	; return calculated value
	return calcDevices as Int
EndFunction

;	Returns a random number between 1 and maxValue
;	@param maxValue		The real maximum value what can be returned
;	@param randomMax	Maximum value for the random function of Papyrus. Should be 100, 1000, ....
;	@return				Returns the random number
int Function Randomizer(int maxValue, float randomMax)
	Log("Randomizer(" + maxValue + "," + randomMax + ")")
	; Maximum number for the randomizer
	float MAX_NUMBER = randomMax
	
	; Any random number between 1 and X
	float randomNumber = Utility.RandomFloat(1,MAX_NUMBER)
	
	; Size of categories e.g. 2 -> 1: 0...50 2: 51..100
	float catSize = MAX_NUMBER / maxValue
	
	; category index
	int i = 1
	
	; Current category
	float category = catSize * i
	While (i <= maxValue)
		; Check if randomNumber is in the current category
		If randomNumber <= category
			; Category found
			return i
		EndIf
	
		; Increase multiplier 
		i = i + 1
		
		; calculate next category value
		category = catSize * i
	EndWhile
	
	; return 0 if something failed // Should never happen
	return 0
EndFunction

Function AcquireSpinlock()
	Log("AcquireSpinlock()")
	While autoSubmitLock
		Utility.Wait(0.1)
	EndWhile
	autoSubmitLock = True
EndFunction

Function ReleaseSpinlock()
	Log("ReleaseSpinlock()")
	autoSubmitLock = False
EndFunction

Function Log(string msg, int level=0)
	If !_SLConfig.LoggingActive
		return
	EndIf
	
	string modName = "[Submit]"
	
	If level == 0
		Debug.Trace(modName + ": " + msg)
	ElseIf level == 1
		Debug.Trace(modName + " **WARNING**: " + msg)
	Else
		Debug.Trace("**************************************************")
		Debug.Trace(modName + " **ERROR**: " + msg)
		Debug.Trace("**************************************************")
	EndIf
EndFunction

Function Warn(string msg)
	Log(msg, 1)
EndFunction

Function Error(string msg)
	Log(msg, 2)
EndFunction


; Removes Package thePackage from all actors who have it
Function RemovePackageFromAllActors(Package thePackage)

	int numberOfActors = StorageUtil.FormListCount(thePackage, "_SLSubmitBullyActorList")
	;debug.notification("Found " + numberOfActors  + " actors")
	int i = 0
	While (i < numberOfActors)
		Actor a = StorageUtil.FormListGet(thePackage,  "_SLSubmitBullyActorList" , i) as Actor
		If (a != None)
			;StorageUtil.FormListRemove(thePackage,"_SLSubmitBullyActorList" , a)
			ActorUtil.RemovePackageOverride(a, thePackage)
			;debug.notification("Removing from " + a.GetActorBase().GetName())
		EndIf
		i+=1
	EndWhile
	StorageUtil.FormListClear(thePackage,"_SLSubmitBullyActorList") 
EndFunction

